//
//  ResamplerNode.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 03. 16..
//

#pragma once

#include "Resampler.hpp"

#include <switchboard_core/SingleBusAudioProcessorNode.hpp>

namespace switchboard {

/**
 * ResamplerNode class.
 * @brief Resamples audio between two audio nodes running with different sample rates. At least one of the input and output sample rate settings has to be set.
 */
class ResamplerNode : public SingleBusAudioProcessorNode {
public:
    /**
     * @brief ResamplerNode constructor.
     */
    ResamplerNode();

    /**
     * @brief ResamplerNode constructor.
     *
     * @param config The configuration map.
     */
    ResamplerNode(std::map<std::string, std::any> config);

    /**
     * @brief Returns the input sample rate.
     *
     * @returns The input sample rate. 0 means undefined sample rate.
     */
    uint getInputSampleRate();

    /**
     * @brief Sets the input sample rate.
     *
     * @param inputSampleRate The input sample rate. 0 means undefined sample rate.
     */
    void setInputSampleRate(const uint inputSampleRate);

    /**
     * @brief Returns the output sample rate.
     *
     * @returns The output sample rate. 0 means undefined sample rate.
     */
    uint getOutputSampleRate();

    /**
     * @brief Sets the output sample rate.
     *
     * @param outputSampleRate The output sample rate. 0 means undefined sample rate.
     */
    void setOutputSampleRate(const uint outputSampleRate);

    // MARK: Overridden methods

    bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat);
    bool process(AudioBus& inBus, AudioBus& outBus);

private:
    uint inputSampleRate;
    uint outputSampleRate;
    Resampler resampler;

    static float getNumberOfFrames(uint sampleRate1, uint numberOfFrames1, uint sampleRate2);
};

}
