//
//  SampleRateRegulator.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include "AudioData.hpp"
#include "Resampler.hpp"
#include "RingBuffer.hpp"

#include <memory>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

using SampleRateRegulatorCallbackFunction = void (*)(float* buffer, uint numberOfSamples, void* userPointer);

/**
 * @brief Converts an audio stream with variable sample rate to a fixed sample rate buffer stream.
 */
class SampleRateRegulator {
public:
    SampleRateRegulator(
        const uint targetSampleRate,
        const SampleRateRegulatorCallbackFunction callback,
        void* userPointer
    );

    bool process(float* buffer, const uint numberOfSamples, const uint sampleRate);

private:
    uint targetSampleRate;
    SampleRateRegulatorCallbackFunction callback;
    void* userPointer;

    Resampler inputResampler;
    Resampler outputResampler;
    std::unique_ptr<RingBuffer<float>> ringBuffer;
    AudioData<float> tempBuffer1;
    AudioData<float> tempBuffer2;
};

}
