//
//  StringPointerParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "StringParameter.hpp"

namespace switchboard {

/**
 * @brief StringPointerParameter class.
 */
class StringPointerParameter : public StringParameter {
public:
    /**
     * @brief StringPointerParameter constructor with a string pointer.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param valuePointer Pointer to the string value.
     */
    StringPointerParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        std::string* valuePointer
    );

    // MARK: Overridden methods

    std::string getValue() const override;
    void setValue(const std::string newValue) override;

private:
    std::string* valuePointer;
};

}
