//
//  TimelineNode.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2025. 02. 12..
//

#pragma once

#include <switchboard_core/AudioSourceNode.hpp>

namespace switchboard {

class TimelineNode : public AudioSourceNode {
    enum Command { NoCommand = 0, Start = 1, Pause = 2, Stop = 3, Jump = 4 };

public:
    TimelineNode();
    TimelineNode(const std::map<std::string, std::any>& config);

    void start();
    void pause();
    void stop();

    void setBpm(float bpm);

    float getPosition() const;
    void setPosition(float position);

    void setLoopEnabled(bool enabled);
    void setLoop(float start, float end);
    void setQuantizedLoop(float quantization, float length);
    void setReverse(bool reverse);

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfBuses) override;
    bool setBusFormats(AudioBusFormatList& busFormats) override;
    bool produce(AudioBusList& buses) override;

    Result<void> setValue(const std::string& key, const std::any& value) override;
    Result<std::any> getValue(const std::string& key) override;
    Result<std::any> callAction(const std::string& actionName, const std::map<std::string, std::any>& params) override;

private:
    uint sampleRate;

    bool isPlaying;
    std::atomic<int> bpm;
    std::atomic<int> framePosition;
    std::atomic<int> nextFramePosition;
    std::atomic<bool> loopEnabled;
    std::atomic<int> loopStart;
    std::atomic<int> loopEnd;
    std::atomic<bool> reverseEnabled;

    std::atomic<Command> command;
    std::atomic<Command> nextCommand;
    std::atomic<bool> nextLoopEnabled;
    std::atomic<int> nextLoopStart;
    std::atomic<int> nextLoopEnd;
    std::atomic<bool> nextReverseEnabled;

    float frameToSeconds(int frame, int sampleRate) const;
    int secondsToFrame(float seconds, int sampleRate) const;
};

}
