//
//  SileroVADExtension.hpp
//  SwitchboardSileroVAD
//
//  Created by Balazs Kiss on 2023. 02. 07..
//

#pragma once

#include <switchboard_core/Extension.hpp>

#if not defined(SWITCHBOARD_WEB)
extern "C" {
    void sb_extension_init(std::map<std::string, std::any> config);
}
#endif

namespace switchboard::extensions::silerovad {

class SileroVADExtension final : public Extension {
public:
    static void initialize();
    static void initialize(std::map<std::string, std::any> config);

    // MARK: Overridden methods

    std::string getName();
    std::shared_ptr<NodeFactory> getNodeFactory();
private:
    SileroVADExtension();

    static SileroVADExtension* sharedInstance;

    class Impl;
    std::unique_ptr<Impl> pImpl;
};
}
