//
//  AudioBus.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 19..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioBuffer.hpp"

namespace switchboard {

/**
 * AudioBus class.
 * @brief Represents a stream of audio in one direction.
 * @details Multiple audio buses can be handled together by the AudioBusList class.
 */
struct AudioBus {
public:
    SB_WASM_EXPORT(AudioBus)

    /**
     * @brief The audio buffer of the audio bus.
     */
    AudioBuffer<float>* buffer = nullptr;

    /**
     * @brief Default audioBus constructor.
     */
    AudioBus() = default;

    /**
     *  @brief AudioBus constructor.
     *
     *  @param buffer The audio buffer containing audio data.
     */
    AudioBus(AudioBuffer<float>* buffer);

    /**
     * @brief Gets the audio buffer of the audio bus.
     * 
     * @returns The audio buffer object.
     */
    SB_WASM AudioBuffer<float>* getBuffer() const;

    /**
     * @brief Sets the audio buffer of the audio bus.
     * 
     * @param newBuffer The new audio buffer to be set.
     */
    SB_WASM void setBuffer(AudioBuffer<float>* newBuffer);

    /**
     * @brief Copies another AudioBus instance.
     */
    SB_WASM void copyFrom(const AudioBus& srcAudioBus);

    /**
     * @brief Sets the content of the audio bus to zero.
     */
    void clear();
};

}
