//
// Created by Balazs Kiss on 2025. 02. 06..
//

#pragma once

#include <any>
#include <functional>
#include <map>
#include <memory>
#include <string>

namespace switchboard {

using EventData = std::any;
using EventCallback = std::function<void(const EventData&)>;

/**
 * @brief Base class for objects that can emit events.
 */
class EventEmitter {
public:

    /**
     * @brief Constructor for the EventEmitter class.
     */
    EventEmitter();

    /**
     * @brief Destructor for the EventEmitter class.
     */
    virtual ~EventEmitter();

    /**
     * @brief Adds a new event listener to the object.
     *
     * @param eventName The name of the event to listen to.
     * @param callback The callback function to call when the event is fired.
     *
     * @return The ID of the listener.
     */
    unsigned int addEventListener(const std::string& eventName, EventCallback callback);

    /**
     * @brief Removes an event listener from the object.
     *
     * @param listenerID The ID of the listener to remove.
     *
     * @return True if the listener was removed, false if the listener was not found.
     */
    bool removeEventListener(unsigned int listenerID);

protected:
    /**
     * @brief Emits an event.
     *
     * @param eventName The name of the event to fire.
     * @param data The data to pass to the event listeners.
     */
    void emitEvent(const std::string& eventName, const EventData& data);

private:
    class Impl;
    std::unique_ptr<Impl> pImpl;
};

}
