//
//  Extension.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 30/08/2024.
//

#pragma once

#include "NodeFactory.hpp"

#include <string>

namespace switchboard {

/**
 * @brief Interface for Switchboard SDK extensions.
 */
class Extension {
public:
    /**
     * @brief Destructor.
     */
    virtual ~Extension() = default;

    /**
     * @brief Gets the name of the extension.
     * 
     * @return std::string The name of the extension.
     */
    virtual std::string getName() = 0;

    /**
     * @brief Gets the NodeFactory object of the extension.
     * @details The NodeFactory object is used to create custom nodes.
     * 
     * @return std::shared_ptr<NodeFactory> The NodeFactory object of the extension.
     */
    virtual std::shared_ptr<NodeFactory> getNodeFactory() = 0;
};

}
