//
//  LogDestination.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 07. 29..
//

#pragma once

#include "LogLevel.hpp"

#include <string>

namespace switchboard {

/**
 * LogDestination abstract class.
 * @brief Provides an interface to implement platform-specific logging.
 * @details Designed to be subclassed.
 */
class LogDestination {
public:
    /**
     * @brief LogDestination destructor.
     */
    virtual ~LogDestination() {}

    /**
     * @brief Logs a log message.
     *
     * @param logLevel The log level.
     * @param logMessage The log message.
     */
    virtual void log(const LogLevel logLevel, const std::string& logMessage) = 0;
};

}
