//
//  NodeFactory.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 07. 05..
//

#pragma once

#include "Node.hpp"

#include <any>
#include <map>
#include <string>

namespace switchboard {

/**
 * NodeFactory class.
 * @brief Creates node instances.
 */
class NodeFactory {
public:
    /**
     * @brief Returns the prefix of the node type.
     * @details The prefix is used to identify the node type and it follows the format: <extension name>.<node type>.
     *
     * @returns The prefix of the node type.
     */
    virtual std::string getNodeTypePrefix() = 0;

    /**
     * @brief Creates an Node instance based on type information.
     * @details The returned node instances need to be freed by the user of the NodeFactory.
     *
     * @param type The type of the node.
     * @param config Configuration values for the node.
     *
     * @returns A pointer to the created Node instance, or nullptr if the node could not be created.
     */
    virtual Node* createNode(const std::string& type, const std::map<std::string, std::any>& config) = 0;
};

}
