//
//  AudioGraphOutputNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include <switchboard_core/AudioSinkNode.hpp>

namespace switchboard {

/**
 * AudioGraphOutputNode class.
 * @brief Represents the output node of the audio graph.
 */
class AudioGraphOutputNode : public AudioSinkNode {
public:
    /**
     * @brief Creates an AudioGraphOutputNode instance.
     */
    AudioGraphOutputNode();

    /**
     * @brief Sets the destination of the audio data.
     * @details The AudioGraph instance is responsible for calling this method.
     *
     * @param graphOutAudioBuses An AudioBusList instance where the audio output will be written to.
     */
    void setGraphOutAudioBuses(const AudioBusList* graphOutAudioBuses);

    /**
     * @brief Gets the number of buses that was set by the AudioGraph.
     *
     * @returns The number of buses.
     */
    uint getNumberOfBuses() const;

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfBuses) override;
    bool setBusFormats(AudioBusFormatList& busFormats) override;
    bool consume(AudioBusList& buses) override;

private:
    const AudioBusList* graphOutAudioBuses;
    uint numberOfBuses;
};

}
