//
//  AudioMemorySource.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2025. 03. 04..
//

#pragma once

#include "Resampler.hpp"

#include <switchboard_core/Switchboard.hpp>
#include <switchboard_v2/Codec.hpp>
#include <vector>

namespace switchboard {

class AudioMemorySource {
public:
    AudioMemorySource(const std::string& filePath, Codec format);

    const uint getSampleRate() const;

    const uint getNumberOfChannels() const;

    const uint getNumberOfFrames() const;

    float getSample(uint channel, int frameIndex) const;

    void setNumberOfChannels(uint newNumberOfChannels);

    void setSampleRate(uint newSampleRate);

    void setRepeat(bool repeat);

    void setStartOffsetSec(double offset);

    void setEndOffsetSec(double offset);

private:
    Resampler resampler;

    std::vector<float> playbackBuffer;
    uint sampleRate;
    uint numberOfChannels;
    uint numberOfFrames;

    std::atomic<bool> repeat;
    std::atomic<double> startOffsetSec;
    std::atomic<double> endOffsetSec;

    AudioMemorySource();

    bool decode(const std::string& filePath, Codec format);
    bool decode(const std::vector<uint8>& inputData, Codec format);
};

}
