//
//  BusSplitterNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 23..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include <switchboard_core/AudioProcessorNode.hpp>

namespace switchboard {

/**
 * BusSplitterNode class
 * @brief Splits a single audio bus into multiple audio buses.
 */
class BusSplitterNode : public AudioProcessorNode {
public:
    SB_WASM_EXPORT(BusSplitterNode)

    /**
     * @brief Creates a BusSplitterNode instance.
     */
    SB_WASM BusSplitterNode();

    // MARK: Overridden methods

    SB_WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    SB_WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    SB_WASM bool process(AudioBusList& inAudioBuses, AudioBusList& outAudioBuses) override;
};

}
