//
//  ChannelSplitterNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include <switchboard_core/AudioProcessorNode.hpp>

namespace switchboard {

/**
 * @brief Splits a multi channel audio bus to multiple mono audio buses.
 */
class ChannelSplitterNode : public AudioProcessorNode {
public:
    SB_WASM_EXPORT(ChannelSplitterNode)

    /**
     * @brief Initializes a ChannelSplitterNode instance.
     */
    SB_WASM ChannelSplitterNode();

    // MARK: Overridden methods

    SB_WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    SB_WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    SB_WASM bool process(AudioBusList& inAudioBuses, AudioBusList& outAudioBuses) override;
};

}
