//
//  ExtensionLoader.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 30/08/2024.
//

#pragma once

#include <any>
#include <map>
#include <string>

namespace switchboard {

/**
 * @brief Loads extension libraries.
 */
class ExtensionLoader {
public:
    /**
     * @brief Loads an extension library.
     * 
     * @param libraryPath The path of the extension library.
     * @param config The configuration of the extension.
     * 
     * @return bool True if the extension library was loaded successfully, false otherwise.
     */
    static bool loadExtensionLibrary(const std::string& libraryPath, const std::map<std::string, std::any>& config);
};

}
