//
//  FileSystem.hpp
//  SwitchboardSDK
//
//  Created by Nádor Iván on 2022. 09. 02..
//

#pragma once

#include <string>

namespace switchboard {

/**
 * FileSystem struct.
 * @brief Contains file manipulation utility methods.
 */
struct FileSystem {

    /**
     *  @brief Check if a file exists.
     *
     *  @param filePath Path to the file.
     *  @returns True if the file exists.
     */
    static bool fileExists(const std::string& filePath);

    /**
     *  @brief Delete the file at filePath.
     *
     *  @param filePath Path to the file.
     *  @returns True if the file is deleted/non-existent.
     */
    static bool deleteFile(const std::string& filePath);

    /**
     *  @brief Checks if the directory exists.
     *
     *  @param path path to the file.
     *  @returns True if the file is a directory.
     */
    static bool isDirectory(const std::string& path);

    /**
     *  @brief Creates a directory.
     *
     *  @param path Path to the directory to be created.
     *  @returns True if the  directory was successfully created.
     */
    static bool createDirectory(const std::string& path);

    /**
     *  @brief Gets extension of the file.
     *
     *  @param path Path to the file to get extension of.
     *  @returns String that contains extension of the input file path.
     */
    static std::string getFileExtension(const std::string& path);

    /**
     *  @brief Gets absolute path of a file from relative path..
     *
     *  @param path Relatiive path to of the file to get absolute path of..
     *  @returns String that contains absolute path.
     */
    static std::string getAbsoluteFilePath(const std::string& path);
};

}
