//
//  FloatPointerParameter.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 26..
//

#pragma once

#include "FloatParameter.hpp"

namespace switchboard {

/**
 * @brief FloatPointerParameter class. A float parameter class that wraps an external float variable.
 */
class FloatPointerParameter : public FloatParameter {
public:
    /**
     * @brief FloatPointerParameter constructor with a float pointer.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param valuePointer Pointer to the float value.
     * @param minimumValue Minimum value for the parameter.
     * @param maximumValue Maximum value for the parameter.
     */
    FloatPointerParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        float* valuePointer,
        const float minimumValue,
        const float maximumValue
    );

    /**
     * @brief FloatPointerParameter constructor with an atomic float pointer.
     *
     * @param name The name of the parameter.
     * @param atomicValuePointer Atomic pointer to the float value.
     * @param minimumValue Minimum value for the parameter.
     * @param maximumValue Maximum value for the parameter.
     */
    FloatPointerParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        std::atomic<float>* atomicValuePointer,
        const float minimumValue,
        const float maximumValue
    );

    // MARK: Overridden methods

    float getValue() const override;
    void setValue(const float newValue) override;
    float getMinimumValue() const override;
    float getMaximumValue() const override;

private:
    float* valuePointer;
    std::atomic<float>* atomicValuePointer;
    float minimumValue;
    float maximumValue;
};

}
