//
//  LFO.hpp
//  SwitchboardAudioEffects
//
//  Created by Balázs Kiss on 2022. 11. 04..
//

#pragma once

#include <atomic>
#include <cmath>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

class LFO {
public:
    LFO();

    float getFrequency();

    void setFrequency(const float newValue);

    float getAmplitude();

    void setAmplitude(const float newValue);

    float getOffset();

    void setOffset(const float newValue);

    float getPhaseOffset();

    void setPhaseOffset(const float newValue);

    float process(int sampleRate);

private:
    std::atomic<float> frequency;
    std::atomic<float> amplitude;
    std::atomic<float> offset;
    std::atomic<float> phaseOffset;
    float phase;
    int lastSampleRate;
    float inverseSampleRate;
};

}
