//
//  Map.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 03..
//

#pragma once

namespace switchboard {

/**
 * @brief Maps a number from one linear range to another.
 * @details If value is outside of the input range, it will be mapped to a value that is also outside of the output range.
 *
 * @param value The value to be mapped.
 * @param inMin Lower bound of the input range.
 * @param inMax Upper bound of the input range.
 * @param outMin Lower bound of the output range.
 * @param outMax Upper bound of the output range.
 */
float map(float value, float inMin, float inMax, float outMin, float outMax);

}
