//
//  MultiChannelToMonoNode.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2022. 12. 29..
//

#pragma once

#include <atomic>
#include <switchboard_core/SingleBusAudioProcessorNode.hpp>

namespace switchboard {

/**
 * @brief Converts a multi-channel audio bus to a mono audio bus.
 */
class MultiChannelToMonoNode : public SingleBusAudioProcessorNode {
public:
    SB_WASM_EXPORT(MultiChannelToMonoNode)

    /**
     * @brief Initializes a MultiChannelToMono instance.
     */
    SB_WASM MultiChannelToMonoNode();

    /**
     * @brief Enables signal normalization to the largest signal after mixing.
     *
     * @param normalize True if the signals have to be normalized to the largest signal after mixing.
     */
    SB_WASM void setNormalize(const bool normalize);

    /**
     * @brief Gets if signal normalization to the largest signal after mixing is enabled.
     *
     * @returns True if the signals have to be normalized to the largest signal after mixing.
     */
    SB_WASM bool getNormalize() const;

    // MARK: Overridden methods

    SB_WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat);
    SB_WASM bool process(AudioBus& inBus, AudioBus& outBus);

private:
    std::atomic<bool> normalize;
};

}
