//
//  RMS.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 01. 06..
//

#pragma once

#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 *  @brief Computes RMS (root mean squared) of inputBuffer.
 *
 *  @param inputBuffer Input buffer.
 *  @param numberOfItems Number of items in the input buffer.
 *
 *  @returns The calculated RMS of the inputBuffer.
 */
template <typename T>
T rms(const T* inputBuffer, const uint numberOfItems) noexcept;

}
