//
//  RresampledSourceNode.hpp
//  SwitchboardSDK
//
//  Created by Gergye Mihály on 2023. 07. 03..
//

#pragma once

#include "Resampler.hpp"

#include <switchboard_core/SingleBusAudioSourceNode.hpp>

namespace switchboard {

/**
 * ResampledSourceNode class.
 * @brief Encapsulates a SingleBusAudioSourceNode and provides environment for it with specified sample rate.
 */
class ResampledSourceNode : public SingleBusAudioSourceNode {
public:
    /**
     * @brief ResampledSourceNode constructor.
     */
    ResampledSourceNode();

    /**
     * @brief ResampledSourceNode constructor with configuration.
     *
     * @param config The configuration map for the node.
     */
    ResampledSourceNode(const std::map<std::string, std::any>& config);

    /**
     * @brief Sets the internal source node for the ResampledSourceNode (the sample rate of the encapsulated source node).
     *
     * @param sourceNode The encapsulated source node.
     */
    void setSourceNode(SingleBusAudioSourceNode* sourceNode);

    /**
     * @brief Returns the internally set sample rate for the source node.
     *
     * @returns The internal sample rate.
     */
    uint getInternalSampleRate() const;

    /**
     * @brief Sets the internal sample rate for the encapsulated source node (the sample rate of the encapsulated source node).
     *
     * @param internalSampleRate The desired internal sample rate.
     */
    void setInternalSampleRate(const uint internalSampleRate);

    // MARK: Overriden methods
    bool setBusFormat(AudioBusFormat& busFormat) override;
    bool produce(AudioBus& bus) override;

private:
    uint internalSampleRate;
    SingleBusAudioSourceNode* sourceNode;
    Resampler resampler;

    RingBuffer<float> ringBuffer;
    AudioData<float> temporaryInData;
    AudioData<float> temporaryOutData;
    AudioData<float> temporaryInterleavedStereoBuffer;
};
} // namespace
