//
//  SineGenerator.hpp
//  SwitchboardAudio
//
//  Created by Balázs Kiss on 2022. 05. 24..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "Generator.hpp"

namespace switchboard {

/**
 * Sine wave generator.
 * @brief Generates a sine wave signal.
 */
class SineGenerator : public Generator {
public:
    /**
     * @brief SineGenerator constructor.
     *
     * @param frequency The initial frequency in Hz. Default value is 440 Hz.
     */
    SineGenerator(const float frequency = 440.0f);

private:
    // MARK: Overridden methods
    float generateSample() override;
};

}
