//
//  StereoBufferSizeRegulator.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 03. 29..
//

#pragma once

#include "RingBuffer.hpp"

#include <memory>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

using StereoBufferSizeRegulatorCallbackFunction = void (*)(float* bufferLeft, float* bufferRight, void* userPointer);

/**
 * @brief Converts a variable sized buffer stream into a fixed sized buffer stream.
 */
class StereoBufferSizeRegulator {
public:
    StereoBufferSizeRegulator(
        const uint targetNumberOfFrames,
        const StereoBufferSizeRegulatorCallbackFunction callback,
        void* userPointer
    );
    ~StereoBufferSizeRegulator();

    bool process(float* bufferLeft, float* bufferRight, const uint numberOfSamples);

private:
    uint targetNumberOfFrames;
    StereoBufferSizeRegulatorCallbackFunction callback;
    void* userPointer;

    std::unique_ptr<RingBuffer<float>> inputBufferLeft;
    std::unique_ptr<RingBuffer<float>> inputBufferRight;
    std::unique_ptr<RingBuffer<float>> outputBufferLeft;
    std::unique_ptr<RingBuffer<float>> outputBufferRight;
    float* tempBufferLeft;
    float* tempBufferRight;
};

}
