
#include "SwitchboardSDK.hpp"

// Utils
#include "Ramp.hpp"

// Math
#include "Limit.hpp"
#include "Map.hpp"
#include "RMS.hpp"

// Audio Buffer
#include "AudioData.hpp"
#include "AudioBufferPool.hpp"

// Ring Buffer
#include "RingBuffer.hpp"
#include "AudioRingBuffer.hpp"

// Resampler
#include "Resampler.hpp"
#include "IOResampler.hpp"
#include "SampleRateRegulator.hpp"
#include "ResamplerNode.hpp"
#include "ResampledSinkNode.hpp"
#include "ResampledSourceNode.hpp"

// Buffer Regulator
#include "BufferRegulator.hpp"
#include "BufferSizeRegulator.hpp"
#include "StereoBufferSizeRegulator.hpp"

// File I/O
#include "FileWriter.hpp"
#include "FileSystem.hpp"

// Audio Bus
#include "AudioBusArray.hpp"
#include "AudioBusFormatArray.hpp"

// Conversion
#include "Deinterleave.hpp"
#include "Interleave.hpp"
#include "FloatToShortInt.hpp"
#include "ShortIntToFloat.hpp"
#include "FloatToInt.hpp"
#include "IntToFloat.hpp"

// Generators
#include "GeneratorType.hpp"
#include "Generator.hpp"
#include "SineGenerator.hpp"

// Audio Node
#include "SineGeneratorNode.hpp"

// Audio Graph
#include "Graph.hpp"
#include "AudioGraphFactory.hpp"
#include "AudioGraph.hpp"
#include "AudioGraphNodeState.hpp"
#include "AudioGraphNodeConnection.hpp"
#include "AudioGraphInputNode.hpp"
#include "AudioGraphOutputNode.hpp"

// Audio Engine
#include "OfflineGraphRenderer.hpp"

// Logger
#include "ConsoleLogDestination.hpp"

// Parameters
#include "BoolParameter.hpp"
#include "FloatCallbackParameter.hpp"
#include "FloatParameter.hpp"
#include "FloatPointerParameter.hpp"
#include "BoolCallbackParameter.hpp"
#include "BoolStoredParameter.hpp"
#include "FloatStoredParameter.hpp"
#include "UIntStoredParameter.hpp"
#include "UIntParameter.hpp"
#include "StringParameter.hpp"
#include "StringCallbackParameter.hpp"
#include "StringPointerParameter.hpp"
#include "StringStoredParameter.hpp"

// Audio Player
#include "Codec.hpp"
#include "AudioPlayer.hpp"
#include "AudioPlayerSource.hpp"

// Ducking
#include "DuckingManager.hpp"
#include "DuckingManagerDelegate.hpp"
#include "DuckingCompressor.hpp"
#include "SimpleDuckingCompressor.hpp"

// Voice Activity Detector
#include "VoiceActivityDetector.hpp"
#include "VoiceActivityDetectorNode.hpp"

// Timeline Nodes
#include "TimelineNode.hpp"
#include "SynchronizedAudioPlayerNode.hpp"
#include "AudioMemorySource.hpp"

// Switchboard Audio Nodes
#include "AudioPlayerNode.hpp"
#include "BusSelectNode.hpp"
#include "BusSplitterNode.hpp"
#include "BusSwitchNode.hpp"
#include "ChannelSplitterNode.hpp"
#include "MusicDuckingNode.hpp"
#include "RecorderNode.hpp"
#include "MonoToMultiChannelNode.hpp"
#include "MultiChannelToMonoNode.hpp"
#include "MixerNode.hpp"
#include "GainNode.hpp"
#include "TapAudioNode.hpp"

// JVM
#include "SBJNI.hpp"
#include "SBJNIObjectMapping.hpp"

// Mute
#include "MuteNode.hpp"

// Audio IO
#include "AudioIO.hpp"
#include "AudioEngine.hpp"

// Extensions
#include "ExtensionManager.hpp"
#include "ExtensionLoader.hpp"

// Utils
#include "CircularBuffer.hpp"
#include "LFO.hpp"
#include "Counter.hpp"