//
//  SynchronizedAudioPlayerNode.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2025. 02. 12..
//

#pragma once

#include "AudioData.hpp"
#include "AudioMemorySource.hpp"

#include <memory>
#include <switchboard_core/SingleBusAudioProcessorNode.hpp>

namespace switchboard {

class SynchronizedAudioPlayerNode : public SingleBusAudioProcessorNode {
public:
    SynchronizedAudioPlayerNode();
    SynchronizedAudioPlayerNode(const std::map<std::string, std::any>& config);

    // MARK: Overridden methods

    bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat) override;
    bool process(AudioBus& inBus, AudioBus& outBus) override;

    void setOffset(double offset);
    void setStartOffset(double offset);
    void setEndOffset(double offset);
    void setRepeat(bool repeat);
    void load(std::string path, Codec format);
    double durationMs();

    Result<void> setValue(const std::string& key, const std::any& value) override;
    Result<std::any> callAction(const std::string& actionName, const std::map<std::string, std::any>& params) override;

private:
    uint sampleRate;
    std::unique_ptr<AudioMemorySource> audioSource;
    uint numberOfChannels;
    std::atomic<int> offsetFrames;
};

}
